/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.api.event;

import java.util.Locale;
import java.util.function.Predicate;

public enum FlowDirection {
    ALL(dir -> true),
    FORWARD,
    BACKWARD;

    final Predicate<FlowDirection> matcher;

    private FlowDirection() {
        this.matcher = dir -> dir.equals((Object)this);
    }

    private FlowDirection(Predicate<FlowDirection> matcher) {
        this.matcher = matcher;
    }

    public boolean isMatch(FlowDirection direction) {
        return this.matcher.test(direction);
    }

    public String format() {
        return this.name().toUpperCase(Locale.ROOT).replaceAll("_", " ");
    }

    public static FlowDirection byId(int id) {
        FlowDirection[] arr = FlowDirection.values();
        int l = arr.length;
        return arr[id % l];
    }
}

